/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.compat.archEx.ArchExCompat;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.data.DamageTypeTagGen;
import com.simibubi.create.foundation.data.recipe.CreateMechanicalCraftingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.CreateSequencedAssemblyRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateStandardRecipeGen;
import com.simibubi.create.foundation.ponder.CreatePonderPlugin;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.infrastructure.data.CreateContraptionTypeTagsProvider;
import com.simibubi.create.infrastructure.data.CreateMountedItemStorageTypeTagsProvider;
import com.simibubi.create.infrastructure.data.CreateRecipeSerializerTagsProvider;
import com.simibubi.create.infrastructure.data.CreateRegistrateTags;
import com.simibubi.create.infrastructure.data.CreateWikiBlockInfoProvider;
import com.simibubi.create.infrastructure.data.GeneratedEntriesProvider;
import com.simibubi.create.infrastructure.data.TagLangGenerator;
import com.simibubi.create.infrastructure.data.VanillaHatOffsetGenerator;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;

public class CreateDatagen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        ExistingFileHelper helper = ExistingFileHelper.withResourcesFromArg();
        FabricDataGenerator.Pack pack = generator.createPack();
        Create.registrate().setupDatagen(pack, helper);
        CreateDatagen.gatherData(pack, helper);
    }

    public void buildRegistry(class_7877 builder) {
        GeneratedEntriesProvider.addBootstraps(builder);
    }

    public static void gatherData(FabricDataGenerator.Pack pack, ExistingFileHelper existingFileHelper) {
        CreateDatagen.addExtraRegistrateData();
        ArchExCompat.init(pack);
        pack.addProvider(AllSoundEvents::provider);
        pack.addProvider(GeneratedEntriesProvider::new);
        pack.addProvider(CreateRecipeSerializerTagsProvider::new);
        pack.addProvider(CreateContraptionTypeTagsProvider::new);
        pack.addProvider(CreateMountedItemStorageTypeTagsProvider::new);
        pack.addProvider(DamageTypeTagGen::new);
        pack.addProvider(AllAdvancements::new);
        pack.addProvider(CreateStandardRecipeGen::new);
        pack.addProvider(CreateMechanicalCraftingRecipeGen::new);
        pack.addProvider(CreateSequencedAssemblyRecipeGen::new);
        pack.addProvider(VanillaHatOffsetGenerator::new);
        pack.addProvider(CreateWikiBlockInfoProvider::new);
        pack.addProvider(CreateRecipeProvider::registerAllProcessing);
    }

    private static void addExtraRegistrateData() {
        CreateRegistrateTags.addGenerators();
        Create.registrate().addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CreateDatagen.provideDefaultLang("interface", langConsumer);
            CreateDatagen.provideDefaultLang("tooltips", langConsumer);
            AllAdvancements.provideLang(langConsumer);
            AllSoundEvents.provideLang(langConsumer);
            AllKeys.provideLang(langConsumer);
            CreateDatagen.providePonderLang(langConsumer);
            new TagLangGenerator(langConsumer).generate();
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/create/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource(path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new CreatePonderPlugin());
        PonderIndex.getLangAccess().provideLang("create", consumer);
    }
}

